package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.api.tooling.internal.DefaultDWAstNode
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.scope.AstNavigator

class ParsingAnnotationProcessorPhase[R <: AstNode, T <: AstNodeResultAware[R]]() extends CompilationPhase[T, T] {

  override def doCall(source: T, context: ParsingContext): PhaseResult[_ <: T] = {
    if (context.hasParsingPhaseAnnotationProcessors) {
      val astNavigator = AstNavigator(source.astNode)
      val annotationNodes = AstNodeHelper.collectChildrenWith(source.astNode, classOf[AnnotationNode])
      if (annotationNodes.nonEmpty) {
        annotationNodes.foreach(f = (annotationNode) => {
          val annotatedNode = astNavigator.parentOf(annotationNode)
          val nameIdentifier = annotationNode.name
          context.parsingPhaseAnnotationProcessorFor(nameIdentifier) match {
            case Some(ap) => ap.run(DefaultDWAstNode(annotatedNode.get, astNavigator, None, None), DefaultDWAstNode(annotationNode, astNavigator, None, None), new DefaultAnnotationContext(context))
            case _        =>
          }
        })
      }
    }
    SuccessResult(source, context)
  }

}
