package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.annotation.SinceAstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNodeHelper
import org.mule.weave.v2.parser.ast.functions.OverloadedFunctionNode
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.scope.AstNavigator
import org.mule.weave.v2.versioncheck.SVersion

/**
  * Injects the labels on the node
  */
class SinceAnnotationProcessor extends AbstractScopeAnnotationProcessor {
  override def run(annotatedNode: AstNode, annotation: AnnotationNode, context: ScopePhaseAnnotationContext): Unit = {
    val astNavigator = context.astNavigator
    val maybeVersion = AnnotationNodeHelper.argString("version", annotation).flatMap(SVersion.fromString)
    if (isFunctionOverloading(annotatedNode, astNavigator)) {
      //Check all overload has Since if not the overload can not have any
      val overloadingFunction = astNavigator.parentWithType(annotatedNode, classOf[OverloadedFunctionNode]).get
      maybeVersion match {
        case Some(versionRestriction) => {
          annotatedNode.annotate(SinceAstNodeAnnotation(versionRestriction))
          val allAnnotated = overloadingFunction.functionDirectives.forall((fd) => fd.codeAnnotation(NameIdentifier.SINCE_ANNOTATION).isDefined)
          if (allAnnotated) {
            val overloadedFunctionDirective = astNavigator.parentWithType(annotatedNode, classOf[FunctionDirectiveNode]).get
            overloadedFunctionDirective.annotation(classOf[SinceAstNodeAnnotation]) match {
              case Some(sinceAstNodeAnnotation) => {
                if (sinceAstNodeAnnotation.version.>=(versionRestriction)) {
                  //We keep the lowest restriction
                  sinceAstNodeAnnotation.version = versionRestriction
                }
              }
              case None => {
                overloadedFunctionDirective.annotate(SinceAstNodeAnnotation(versionRestriction))
              }
            }
          }
        }
        case None =>
      }
    } else {
      annotatedNode match {
        case _ => {
          maybeVersion match {
            case Some(value) => {
              annotatedNode.annotate(SinceAstNodeAnnotation(value))
            }
            case None =>
          }
        }
      }
    }

  }

  private def isFunctionOverloading(annotatedNode: AstNode, astNavigator: AstNavigator) = {
    annotatedNode.isInstanceOf[FunctionDirectiveNode] && astNavigator.isChildOf(annotatedNode, classOf[OverloadedFunctionNode])
  }
}
