package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.InvalidWeaveVersion
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.header.directives.VersionDirective
import org.mule.weave.v2.utils.DataWeaveVersion

class VersionCheckerPhase[T <: AstNode] extends CompilationPhase[ParsingResult[T], ParsingResult[T]] {
  override def doCall(source: ParsingResult[T], context: ParsingContext): PhaseResult[_ <: ParsingResult[T]] = {
    val childrenWith: Seq[VersionDirective] = AstNodeHelper.collectChildrenWith(source.astNode, classOf[VersionDirective])
    if (childrenWith.nonEmpty) {
      val versionDirective = childrenWith.head
      val majorVersion: Int = versionDirective.major.v.toInt
      val minorVersion: Int = versionDirective.minor.v.toInt
      val runtimeVersion = VersionCheckerPhase.getWeaveVersion

      if (majorVersion != runtimeVersion.major || minorVersion > runtimeVersion.minor) {
        context.messageCollector.error(InvalidWeaveVersion(
          s"${runtimeVersion.major}.${runtimeVersion.minor}",
          s"$majorVersion.$minorVersion"), versionDirective.location())
        FailureResult(context)
      } else {
        SuccessResult(source, context)
      }
    } else {
      SuccessResult(source, context)
    }
  }

}

object VersionCheckerPhase extends VersionCheckerPhase {
  lazy val getWeaveVersion: DataWeaveVersion = DataWeaveVersion()
}
