package org.mule.weave.v2.sdk.selectors

import org.mule.weave.v2.parser.PropertyNotDefined
import org.mule.weave.v2.ts.KeyType
import org.mule.weave.v2.ts.KeyValuePairType
import org.mule.weave.v2.ts.NameType
import org.mule.weave.v2.ts.ObjectType
import org.mule.weave.v2.ts.TypeHelper.hasPatternProperty
import org.mule.weave.v2.ts.TypeHelper.unify
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.resolvers.NameTypeResolver

object ValueSelectorCustomTypeResolver extends BaseValueSelectorCustomTypeResolver {

  override def select(leftType: WeaveType, selector: WeaveType, ctx: WeaveTypeResolutionContext, node: TypeNode, insideArray: Boolean): SelectionResult = {
    val mayBeName: Option[NameType] = getSelectorNameType(selector)
    if (mayBeName.isEmpty) {
      Unknown
    } else {
      val name: NameType = mayBeName.get
      leftType match {
        case ObjectType(properties, close, _) => {
          name.value match {
            case Some(selectedName) => {
              val selectedType: Option[WeaveType] = properties
                .find((prop) => {
                  prop.key match {
                    case KeyType(NameType(Some(propName)), _) => {
                      propName.selectedBy(selectedName)
                    }
                    case name => {
                      val asNameType = NameTypeResolver.toNameType(name, None)
                      asNameType match {
                        case Some(NameType(Some(propName))) => propName.selectedBy(selectedName)
                        case _                              => false
                      }
                    }
                  }
                })
                .orElse({
                  properties.find(_.key match {
                    case KeyType(NameType(None), _) => true
                    case name => {
                      val asNameType = NameTypeResolver.toNameType(name, None)
                      asNameType match {
                        case Some(NameType(None)) => true
                        case _                    => false
                      }
                    }
                  })
                })
                .map((prop) => {
                  prop.value.withOptional(prop.optional)
                })
              selectedType match {
                case Some(value) => Matched(value)
                case None => {
                  if (close) {
                    ctx.warning(PropertyNotDefined(selectedName.name, properties.collect({ case KeyValuePairType(KeyType(NameType(Some(keyname)), _), _, _, _) => keyname.name }), leftType), node)
                    NoMatch(true)
                  } else {
                    NoMatch(false)
                  }
                }
              }
            }
            case None => {
              //Dynamic selection
              if (properties.isEmpty && close) {
                NoMatch(close)
              } else {
                if (close || hasPatternProperty(properties)) {
                  ///We can only determine something if we know what kind of values this object has. And that can only be applied if the value is close
                  // or it has a wildcard that limits the possible values, like a dictionary
                  val weaveType: WeaveType = unify(properties.map(_.value))
                  //On dynamic cases we should always mark it as optional
                  // as we don't know if something is going to match or not
                  weaveType.markOptional()
                  Matched(weaveType)
                } else {
                  NoMatch(closed = false)
                }
              }
            }
          }
        }
        case _ => Unknown
      }
    }
  }
}
