package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.Edge
import org.mule.weave.v2.ts.EdgeLabels
import org.mule.weave.v2.ts.KeyType
import org.mule.weave.v2.ts.NameType
import org.mule.weave.v2.ts.NameValuePairType
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

object NameValuePairTypeResolver extends WeaveTypeResolver {

  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val name: Edge = nameEdge(node)
    val value: Edge = valueEdge(node)
    Some(NameValuePairType(name.incomingType(), value.incomingType()))
  }

  override def resolveExpectedType(node: TypeNode, incomingExpectedType: Option[WeaveType], ctx: WeaveTypeResolutionContext): Seq[(Edge, WeaveType)] = {
    incomingExpectedType match {
      case Some(nvp: NameValuePairType) => {
        Seq((nameEdge(node), nvp.name), (valueEdge(node), nvp.value))
      }
      case _ => Seq()
    }
  }

  def selectNameValuePair(node: TypeNode, keyType: KeyType): Option[NameValuePairType] = {
    nameEdge(node).incomingType() match {
      case NameType(Some(qName)) => {
        keyType.attrs.find((nvp) => {
          nvp.name match {
            case NameType(Some(incomingQName)) => {
              incomingQName.matchesPattern(qName)
            }
            case _ => false
          }
        })
      }
      case _ => None
    }
  }

  private def valueEdge(node: TypeNode) = {
    node.incomingEdges(EdgeLabels.VALUE).head
  }

  private def nameEdge(node: TypeNode) = {
    node.incomingEdges(EdgeLabels.NAME).head
  }

}
