package org.mule.weave.v2.editor

import org.mule.weave.v2.annotations.WeaveApi
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.WeaveType

/**
  * Simplified utils for tooling to interact with types
  */
@WeaveApi(Seq("Studio"))
object WeaveToolingTypeHelper {

  /**
    * Returns true if they can be assigned
    * @param expected The expected type
    * @param actual The actual type
    * @return True if they can be assigned
    */
  def canBeAssigned(expected: WeaveType, actual: WeaveType): Boolean = {
    TypeHelper.canBeSubstituted(actual, expected, null);
  }

  /**
    * Returns true if they can be substituted
    * @param expected The expected type
    * @param actual The actual type
    * @return True if they can be assigned
    */
  def canBeSubstituted(expected: WeaveType, actual: WeaveType): Boolean = {
    TypeHelper.canBeSubstituted(actual, expected, null);
  }

}
