package org.mule.weave.v2.inspector

import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.phase.CompilationPhase
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.parser.phase.PhaseResult
import org.mule.weave.v2.parser.phase.SuccessResult
import org.mule.weave.v2.parser.phase.TypeCheckingResult

class TypeCodeInspectorPhase[R <: AstNode](inspectors: Seq[CodeInspector[TypeCheckingResult[_ <: AstNode]]]) extends CompilationPhase[TypeCheckingResult[R], TypeCheckingResult[R]] {

  override def doCall(source: TypeCheckingResult[R], context: ParsingContext): PhaseResult[TypeCheckingResult[R]] = {
    val rootNode: R = source.astNode
    AstNodeHelper.traverse(rootNode, (node) => {
      inspectors.foreach((inspector) => {
        inspector.inspect(node, source, context)
      })
      true
    })
    SuccessResult(source, context)
  }
}
