package org.mule.weave.v2.parser.ast

import org.mule.weave.v2.codegen.CodeGenerator
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.location.Position
import org.mule.weave.v2.parser.location.SimpleParserPosition
import org.mule.weave.v2.parser.location.WeaveLocation

object LocationInjectorHelper {

  def injectPosition[T <: AstNode](node: T): T = {
    injectPosition(node, 0)
    node
  }

  private def injectPosition(node: AstNode, index: Int): Int = {
    val startLocation = index
    val children = node.children().iterator
    var currentIndex = index
    while (children.hasNext) {
      val next = children.next()
      currentIndex = injectPosition(next, currentIndex + 1)
    }
    val endLocation = currentIndex + 1
    val startPosition = SimpleParserPosition(startLocation, -1, -1, () => CodeGenerator.generate(node))
    val endPosition = SimpleParserPosition(endLocation, -1, -1, () => CodeGenerator.generate(node))
    node._location = Some(new ExtendedWeaveLocation(startPosition, endPosition, node._location.map(_.resourceName).getOrElse(NameIdentifier.anonymous), node._location))
    endLocation
  }
}

class ExtendedWeaveLocation(_strPosition: Position, _endPosition: Position, _resourceName: NameIdentifier, originalPosition: Option[WeaveLocation]) extends WeaveLocation(_strPosition, _endPosition, _resourceName)
