package org.mule.weave.v2.parser.ast

import org.mule.weave.v2.api.tooling.ts.{ QName => ApiQName }
import org.mule.weave.v2.utils.Optionals.toJavaOptional

import java.util.Optional

case class QName(name: String, ns: Option[String] = None) extends ApiQName {

  /**
    * If true, this QName will match any QName with the same name,
    * regardless the namespace, when comparing it as a pattern with
    * matchesPattern.
    */
  var matchesAllNs = false

  /**
    * Returns true if the specified name <selector> matches this name.
    * This mean that if the specified selector doesn't specifiy ns it will only check if the two local names are equal
    * @param qname Te name to match with
    * @return
    */
  def selectedBy(qname: QName): Boolean = {
    if (qname.ns.isDefined) {
      if (ns.isEmpty) {
        false
      } else {
        qname.ns.get.equals(ns.get) && qname.name.equals(name)
      }
    } else {
      qname.name.equals(name)
    }
  }

  /**
    * Will compare two QName as patterns, if any of those have
    * matchesAllNs set to true, it will disregard the namespace.
    *
    * @param other
    * @return
    */
  def matchesPattern(other: QName): Boolean = {
    if (matchesAllNs || other.matchesAllNs) {
      name.equals(other.name)
    } else {
      this.equals(other)
    }
  }

  override def getName: String = {
    name
  }

  override def getNamespace: Optional[String] = {
    ns.asJava
  }
}

object QName {
  /**
    * Creates QName that matches all namespaces
    *
    * @param name
    * @return
    */
  def matchingAllNs(name: String): QName = {
    val res = QName(name)
    res.matchesAllNs = true
    res
  }
}
