package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.MutableAstNode

case class NameValuePairNode(var key: AstNode, var value: AstNode, var cond: Option[AstNode] = None) extends AstNode with MutableAstNode {
  override def children(): Seq[AstNode] = Children(key, value).+=(cond).result()

  override protected def doClone(): AstNode = {
    copy(key.cloneAst(), value.cloneAst(), cond.map(_.cloneAst()))
  }

  /**
    * Replace the child node that is equals to the given node with the new one
    *
    * @param toBeReplaced The node to be replaced
    * @param withNode     The replacement
    */
  override def update(toBeReplaced: AstNode, withNode: AstNode): Unit = {
    if (toBeReplaced eq key) {
      key = withNode
    } else if (toBeReplaced eq value) {
      value = withNode
    } else if (cond.exists(_ eq toBeReplaced)) {
      cond = Some(withNode)
    }
  }

  override def getKind(): String = DWAstNodeKind.NAME_VALUE_PAIR_NODE
}
