package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.annotation.LabelsAstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNodeHelper
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.functions.OverloadedFunctionNode
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode

/**
  * Injects the labels on the node
  */
class LabelsAnnotationProcessor extends AbstractCanonicalAnnotationProcessor {
  override def run(annotatedNode: AstNode, annotation: AnnotationNode, context: CanonicalPhaseAnnotationContext): Unit = {
    val labels = AnnotationNodeHelper.argStringSeq("labels", annotation).getOrElse(Seq())
    val labelsAstNodeAnnotation = LabelsAstNodeAnnotation(labels.toArray)
    annotatedNode match {
      case fd: FunctionDirectiveNode => {
        fd.literal match {
          case fn: FunctionNode => fn.annotate(labelsAstNodeAnnotation)
          case ofn: OverloadedFunctionNode => {
            ofn.functions.foreach(fn => {
              fn.annotate(labelsAstNodeAnnotation)
            })
          }
          case _ => annotatedNode.annotate(labelsAstNodeAnnotation)
        }
      }
      case _ => {
        annotatedNode.annotate(labelsAstNodeAnnotation)
      }
    }
  }
}
