package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.grammar.ValueSelectorOpId
import org.mule.weave.v2.parser.MappingParser
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.LocationInjectorHelper
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode
import org.mule.weave.v2.parser.ast.functions.FunctionCallParametersNode
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.functions.FunctionParameter
import org.mule.weave.v2.parser.ast.functions.FunctionParameters
import org.mule.weave.v2.parser.ast.functions.UsingNode
import org.mule.weave.v2.parser.ast.functions.UsingVariableAssignment
import org.mule.weave.v2.parser.ast.functions.UsingVariableAssignments
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.ImportDirective
import org.mule.weave.v2.parser.ast.header.directives.InputDirective
import org.mule.weave.v2.parser.ast.header.directives.NamespaceDirective
import org.mule.weave.v2.parser.ast.header.directives.TypeDirective
import org.mule.weave.v2.parser.ast.header.directives.VarDirective
import org.mule.weave.v2.parser.ast.module.ModuleNode
import org.mule.weave.v2.parser.ast.operators.BinaryOpNode
import org.mule.weave.v2.parser.ast.selectors.NullSafeNode
import org.mule.weave.v2.parser.ast.structure.DocumentNode
import org.mule.weave.v2.parser.ast.structure.KeyNode
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode
import org.mule.weave.v2.parser.ast.structure.NameNode
import org.mule.weave.v2.parser.ast.structure.ObjectNode
import org.mule.weave.v2.parser.ast.structure.StringNode
import org.mule.weave.v2.parser.ast.types.ObjectTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode
import org.mule.weave.v2.sdk.WeaveResource

object MappingToModuleAdaptor {

  def mappingAsModuleNode(nameIdentifier: NameIdentifier, resource: WeaveResource, parsingContext: ParsingContext): PhaseResult[ParsingResult[ModuleNode]] = {
    val parse: PhaseResult[ParsingResult[DocumentNode]] = MappingParser.parse(MappingParser.canonicalAstPhase(), resource, parsingContext)
    parse.map((result) => {
      val documentNode: DocumentNode = result.astNode
      val mainFunctionDirective: FunctionDirectiveNode = buildMainFunction(result, documentNode)
      val bindFunctionDirective: FunctionDirectiveNode = buildBindFunction(result, documentNode)
      val directives = documentNode.header.directives.collect({
        case td: TypeDirective      => td
        case nd: NamespaceDirective => nd
        case id: ImportDirective    => id
      }) :+ mainFunctionDirective :+ bindFunctionDirective
      //Mocks the position injection
      val node: ModuleNode = LocationInjectorHelper.injectPosition(ModuleNode(nameIdentifier, directives))
      result.copy(astNode = node)
    })
  }

  def buildMainFunction(result: ParsingResult[DocumentNode], documentNode: DocumentNode): FunctionDirectiveNode = {
    //Inputs
    val inputDirectives: Seq[InputDirective] = documentNode.header.directives.collect({ case id: InputDirective => id })
    val inputVariables: Seq[UsingVariableAssignment] = inputDirectives.map((inputDirective) => {
      val valueSelector: AstNode = NullSafeNode(BinaryOpNode(ValueSelectorOpId, VariableReferenceNode(NameIdentifier("context")), NameNode(StringNode(inputDirective.variable.name))))
      UsingVariableAssignment(inputDirective.variable, valueSelector)
    })

    //Variables and Functions
    val variablesAndFunctions: Seq[DirectiveNode] = result.astNode.header.directives.collect({
      case fd: FunctionDirectiveNode => fd
      case vd: VarDirective          => vd
    })
    val variablesAndFunctionAsParameters: Seq[UsingVariableAssignment] = variablesAndFunctions.map({
      case fd: FunctionDirectiveNode => UsingVariableAssignment(fd.variable, fd.literal)
      case vd: VarDirective          => UsingVariableAssignment(vd.variable, vd.value)
    })
    val mainFunctionBody: UsingNode = UsingNode(UsingVariableAssignments(inputVariables), UsingNode(UsingVariableAssignments(variablesAndFunctionAsParameters), documentNode.root))

    val mainParameters: FunctionParameters = FunctionParameters(Seq(FunctionParameter(NameIdentifier("context"), None, None)))
    FunctionDirectiveNode(NameIdentifier("main"), FunctionNode(mainParameters, mainFunctionBody))
  }

  def buildBindFunction(result: ParsingResult[DocumentNode], documentNode: DocumentNode): FunctionDirectiveNode = {

    val inputDirectives: Seq[InputDirective] = documentNode.header.directives.collect({ case id: InputDirective => id })
    val inputVariables: Seq[UsingVariableAssignment] = inputDirectives.map((inputDirective) => {
      val valueSelector: AstNode = NullSafeNode(BinaryOpNode(ValueSelectorOpId, VariableReferenceNode(NameIdentifier("context")), NameNode(StringNode(inputDirective.variable.name))))
      UsingVariableAssignment(inputDirective.variable, valueSelector)
    })

    val variablesAndFunctions: Seq[DirectiveNode] = result.astNode.header.directives.collect({
      case fd: FunctionDirectiveNode => fd
      case vd: VarDirective          => vd
    })

    //The entire object with all the functions and variables
    val variablesAndFunctionAsKVP: Seq[KeyValuePairNode] = variablesAndFunctions.map({
      case fd: FunctionDirectiveNode => KeyValuePairNode(KeyNode(StringNode(fd.variable.name), None, None), VariableReferenceNode(fd.variable))
      case vd: VarDirective          => KeyValuePairNode(KeyNode(StringNode(vd.variable.name), None, None), VariableReferenceNode(vd.variable))
    }) :+ KeyValuePairNode(KeyNode(StringNode("main"), None, None), FunctionNode(FunctionParameters(Seq()), FunctionCallNode(VariableReferenceNode(NameIdentifier("main")), FunctionCallParametersNode(Seq(VariableReferenceNode(NameIdentifier("context")))))))

    val variablesAndFunctionAsParameters: Seq[UsingVariableAssignment] = variablesAndFunctions.map({
      case fd: FunctionDirectiveNode => UsingVariableAssignment(fd.variable, fd.literal)
      case vd: VarDirective          => UsingVariableAssignment(vd.variable, vd.value)
    })

    val bindFunctionBody: UsingNode = UsingNode(UsingVariableAssignments(inputVariables), UsingNode(UsingVariableAssignments(variablesAndFunctionAsParameters), ObjectNode(variablesAndFunctionAsKVP)))
    val bindFunctionParameters: FunctionParameters = FunctionParameters(Seq(FunctionParameter(NameIdentifier("context"), None, None)))
    FunctionDirectiveNode(NameIdentifier("bind"), FunctionNode(bindFunctionParameters, bindFunctionBody))
  }
}
