package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.DuplicatedParameterMessage
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.FunctionNode

/**
  * Validates two function parameters doesn't have the same name
  */
class UniqueNameFunctionParametersValidation extends AstNodeVerifier {
  override def verify(node: AstNode, context: ParsingContext): Unit = {
    node match {
      case FunctionNode(params, _, _, _) => {
        params.paramList.groupBy((param) => {
          param.variable.name
        })
          .foreach({
            case (x, ys) if ys.size > 1 => {
              ys.foreach((parameter) => {
                context.messageCollector.error(DuplicatedParameterMessage(x), parameter.location())
              })
            }
            case _ =>

          })
      }
      case _ =>
    }
  }

}
