package org.mule.weave.v2.sdk.selectors

import org.mule.weave.v2.ts.AnyType
import org.mule.weave.v2.ts.ArrayType
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeHelper.unify
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext

object MultiAttributeSelectorCustomTypeResolver extends BaseValueSelectorCustomTypeResolver {

  /**
    * Attribute MultiValue selector flattens on Array selection (org.mule.weave.v2.runtime.core.operator.selectors.ArrayAttributeMultiValueSelectorOperator)
    */
  override protected def resolveSelectionOverArray(nameType: WeaveType, ctx: WeaveTypeResolutionContext, node: TypeNode, of: WeaveType): SelectionResult = {
    val result = resolve(of, nameType, ctx, node, insideArray = true)
    result match {
      case NoMatch(closed) => {
        if (closed) {
          NoMatch(closed)
        } else {
          Matched(ArrayType(AnyType()).markOptional())
        }
      }
      case Unknown => Unknown
      case Matched(weaveType) => {
        Matched(weaveType)
      }
    }
  }

  override def select(leftType: WeaveType, selector: WeaveType, ctx: WeaveTypeResolutionContext, node: TypeNode, insideArray: Boolean): SelectionResult = {
    val maybeNameType = getSelectorNameType(selector)
    if (maybeNameType.isEmpty) {
      Unknown
    } else {
      val name = maybeNameType.get
      leftType.parentKey match {
        case Some(parentKey) => {
          name.value match {
            case Some(_) => {
              val types: Seq[WeaveType] = parentKey.attrs
                .filter((attr) => TypeHelper.canBeAssignedTo(attr.name, name, ctx))
                .map(_.value)
              if (types.isEmpty) {
                NoMatch(true)
              } else {
                Matched(ArrayType(unify(types)))
              }
            }
            case None =>
              val types = parentKey.attrs.map(_.value.baseType())
              if (types.isEmpty) {
                NoMatch(true)
              } else {
                val weaveType = unify(types).markOptional()
                Matched(ArrayType(weaveType))
              }
          }
        }
        case _ => Unknown
      }
    }
  }
}
