package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.NullType
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.UnionType
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

import scala.collection.Seq

object DefaultTypeResolver extends WeaveTypeResolver {

  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val incomingTypes: Seq[WeaveType] = node.incomingTypes()
    val leftType = incomingTypes.head
    val rightType = incomingTypes.last
    val filteredType = leftType match {
      case UnionType(of) => TypeHelper.unify(of.filterNot((wt) => TypeHelper.canBeAssignedTo(wt, NullType(), ctx)).:+(rightType))
      case _: NullType   => rightType
      case _             => TypeHelper.unify(Seq(leftType, rightType))
    }
    Some(filteredType)
  }
}
