package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.parser.Message
import org.mule.weave.v2.parser.location.WeaveLocation
import org.mule.weave.v2.ts.FunctionType
import org.mule.weave.v2.ts.WeaveType

import scala.collection.Seq

case class ResolutionResult(success: Boolean = false, typeParametersSuccess: Boolean = true, functionType: Option[FunctionType] = None, result: Option[WeaveType] = None, messages: Seq[(FunctionType, Seq[(WeaveLocation, Message)])] = Seq()) {
  def failure: Boolean = !success
  def typeParamFailure: Boolean = !typeParametersSuccess
}
