package org.mule.weave.v2.utils

import org.mule.weave.v2.parser.annotation.MetadataAnnotationSchemaAnnotation
import org.mule.weave.v2.parser.ast.structure.schema.SchemaNode

sealed trait SchemaNodeOrigin

case object AnnotationSchemaNode extends SchemaNodeOrigin

case object ExplicitSchemaNode extends SchemaNodeOrigin

object SchemaNodeOrigin {

  def apply(schemaNode: SchemaNode): SchemaNodeOrigin = if (schemaNode.isAnnotatedWith(classOf[MetadataAnnotationSchemaAnnotation])) {
    AnnotationSchemaNode
  } else {
    ExplicitSchemaNode
  }
}