package org.mule.weave.v2.versioncheck

import java.util.regex.Pattern

case class SVersion(mayor: Int, minor: Int, patch: Int) {
  def semVerString(): String = s"${mayor}.${minor}.${patch}"

  def <=(otherVersion: SVersion): Boolean = {
    otherVersion.>=(this)
  }

  def >=(otherVersion: SVersion): Boolean = {
    greater(otherVersion, equal = true)
  }

  def >(otherVersion: SVersion): Boolean = {
    greater(otherVersion, equal = false)
  }

  private def greater(otherVersion: SVersion, equal: Boolean) = {
    if (mayor == otherVersion.mayor) {
      if (minor == otherVersion.minor) {
        if (equal) {
          patch >= otherVersion.patch
        } else {
          patch > otherVersion.patch
        }
      } else {
        minor > otherVersion.minor
      }
    } else {
      mayor > otherVersion.mayor
    }
  }
}

object SVersion {

  val _230: SVersion = SVersion(2, 3, 0)

  val _250: SVersion = SVersion(2, 5, 0)

  val _280: SVersion = SVersion(2, 8, 0)

  private val SEMVER = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$")

  def fromString(sversion: String): Option[SVersion] = {
    val matcher = SEMVER.matcher(sversion)
    if (matcher.matches()) {
      val mayor = Integer.parseInt(matcher.group(1))
      val minor = Integer.parseInt(matcher.group(2))
      val patch = Integer.parseInt(matcher.group(3))
      Some(SVersion(mayor, minor, patch))
    } else {
      None
    }
  }
}
