package org.mule.weave.v2.parser.ast.conditional

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.ExpressionAstNode
import org.mule.weave.v2.parser.ast.MutableAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode

case class UnlessNode(var ifExpr: AstNode, var condition: AstNode, var elseExpr: AstNode, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends ExpressionAstNode with MutableAstNode {

  override def children(): Seq[AstNode] = Children(ifExpr, condition, elseExpr).++=(codeAnnotations).result()

  override protected def doClone(): AstNode = {
    copy(ifExpr.cloneAst(), condition.cloneAst(), elseExpr.cloneAst(), codeAnnotations.map(_.cloneAst()))
  }

  override def update(toBeReplaced: AstNode, withNode: AstNode): Unit = {
    if (toBeReplaced eq ifExpr) {
      ifExpr = withNode
    } else if (toBeReplaced eq condition) {
      condition = withNode
    } else if (toBeReplaced eq elseExpr) {
      elseExpr = withNode
    }
  }

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  override def getKind(): String = DWAstNodeKind.UNLESS_NODE
}
