package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.ExpressionAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode

case class ObjectNode(var elements: Seq[AstNode], var codeAnnotations: Seq[AnnotationNode] = Seq()) extends ExpressionAstNode {
  override def children(): Seq[AstNode] = Children().++=(elements).++=(codeAnnotations).result()

  override protected def doClone(): AstNode = {
    copy(elements.map(_.cloneAst()), codeAnnotations.map(_.cloneAst()))
  }

  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  override def getKind(): String = DWAstNodeKind.OBJECT_NODE
}
