package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.annotation.InjectedNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.header.HeaderNode
import org.mule.weave.v2.parser.ast.header.directives.ImportDirective
import org.mule.weave.v2.parser.ast.header.directives.ImportedElement
import org.mule.weave.v2.parser.ast.header.directives.ImportedElements
import org.mule.weave.v2.parser.ast.module.ModuleNode
import org.mule.weave.v2.parser.ast.structure.DocumentNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

class ImplicitImportsTransformer extends AstNodeTransformer {
  override def transform(node: AstNode, context: ParsingContext): Unit = {
    node match {
      case doc: DocumentNode => {
        context.implicitImports.foreach((qname) =>
          doc.header.directives = doc.header.directives :+ createImportDirective(qname))
      }
      case mn: ModuleNode => {
        // Add all implicit imports, except itself
        context.implicitImports
          .filter((qname) => qname != mn.name.name)
          .foreach((qname) =>
            mn.elements = mn.elements :+ createImportDirective(qname))
      }
      case _ =>
    }
  }

  def createImportDirective(qname: String): ImportDirective = {
    val result = ImportDirective(ImportedElement(NameIdentifier(qname)), ImportedElements(Seq(ImportedElement(NameIdentifier.$star))))
    result.annotate(InjectedNodeAnnotation())
    result
  }
}