%dw 2.0
ns cerpt http://com.workday.report/Employee_Canonical_Enrichment
ns pcommrpt http://com.workday.report/ei_soa_api_worker/Peopleforce_Extract
ns wd http://com.workday/bsvc
ns self http://sfdc.com/it/ei/esb/xmlns
ns hr http://www.hr-xml.org/3
ns oa http://www.openapplications.org/oagis/9
ns eihrsum http://sfdc.com/it/ei/hr/summary
ns eihremp http://sfdc.com/it/ei/hr/employee
ns eihrempmnt http://sfdc.com/it/ei/hr/employment
ns eihrdeploy http://sfdc.com/it/ei/hr/deployment
ns eihrremun http://sfdc.com/it/ei/hr/remuneration
---
{
eihrsum#HRMasterDataBatch: in0.EmployeeSummary.EmployeeWorkersData.Response_Data.Worker* map {
        eihrsum#HRMasterData @(validFrom: in1.parameters.validFrom): {
            hr#MasterPersonDossier @(validFrom: $.validFrom): {
                hr#MasterPerson: {
                    PersonName @(legalNameIndicator: false): {
                        GivenName: (&firstPersonaData $.Worker_Data.Personal_Data.Name_Data.Preferred_Name_Data.Name_Detail_Data).First_Name,
                        FamilyName: firstPersonaData.Last_Name
                    },
                    PersonName @(legalNameIndicator: true): {
                        GivenName: (&secondPersonaData $.Worker_Data.Personal_Data.Name_Data.Legal_Name_Data.Name_Detail_Data).First_Name,
                        FamilyName: secondPersonaData.Last_Name
                    }
                }
                    + {PersonLegalID @(schemeName:"SSN"):  if (sizeOf(in0.EmployeeSummary.EmployeeWorkersData.Response_Data.Worker*) > 0) 1 else 2}
                    + {
                        Communication: if($.Worker_Data.Personal_Data.Contact_Data.Phone_Data.Usage_Data.Type_Data.Primary == 1)
                                        {
                                            a:2
                                        }
                                       else
                                        {
                                            b: $.Worker_Data.Personal_Data.Contact_Data.Phone_Data.Usage_Data.Type_Data
                                        }
                     }
            }
        }
    }
}