import try, fail from dw::Runtime
import dw::core::Assertions
fun then<A, V>(result: A, assertions: (result: A) -> V): V = assertions(result)


fun shouldFail2() = fail("Test")
fun shouldFail1() = shouldFail2()
fun shouldFail() = shouldFail1()

fun shouldNotFail() = 123

---
[
  try(() -> (1 / 0)) then [
    Assertions::mustEqual($.success, false)
  ],

  try(shouldFail) then [
    Assertions::mustEqual($.success, false),
    Assertions::mustEqual($.error.message, "Test"),
    Assertions::mustEqual(sizeOf($.error.stack!), 3),
    Assertions::mustEqual($.error.kind, "UserException"),
    Assertions::mustEqual($.result?, false)
  ],

  try(shouldNotFail) then [
    Assertions::mustEqual($.success, true),
    Assertions::mustEqual($.error?, false),
    Assertions::mustEqual($.result, 123)
  ]
] is Array