
import fail from dw::Runtime
import dw::core::Binaries
import dw::core::Strings

fun assert(a, b, message: String = ''): Boolean =
  if (a == b)
    true
  else
    using(
      x = fail(
'$message
  "$(a default 'Null')" ($(typeOf(a))) did not match
  "$(b default 'Null')" ($(typeOf(b)))')
    )
      false

fun test(list: Array<Boolean>): Boolean = list reduce ($ and $$)

---
test([
  assert(
    Binaries::toHex("`1234567890-=qwertyuiop[]\asdfghjkl;'zxcvbnm,./~!@#\$%^&*()_+QWERTYUIOP{}|ASDFGHJKL:\"ZXCVBNM<>?"),
    "60313233343536373839302D3D71776572747975696F705B5D5C6173646667686A6B6C3B277A786376626E6D2C2E2F7E21402324255E262A28295F2B51574552545955494F507B7D7C4153444647484A4B4C3A225A584356424E4D3C3E3F",
    'toHex'
  ),
  assert(
    "`1234567890-=qwertyuiop[]\asdfghjkl;'zxcvbnm,./~!@#\$%^&*()_+QWERTYUIOP{}|ASDFGHJKL:\"ZXCVBNM<>?" as Binary,
    Binaries::fromHex('60313233343536373839302D3D71776572747975696F705B5D5C6173646667686A6B6C3B277A786376626E6D2C2E2F7E21402324255E262A28295F2B51574552545955494F507B7D7C4153444647484A4B4C3A225A584356424E4D3C3E3F'),
    'fromHex'
  ),
  assert(Binaries::toHex('🀅'), 'F09F8085'),
  assert(sizeOf('🀅'), 2, 'Size of unicode char must be 2'),
  assert(Strings::charCode('🀅'[0]), 55356),
  assert(Strings::charCode('🀅'[1]), 56325),
  assert(Strings::fromCharCode(55356) ++ Strings::fromCharCode(56325), '🀅', 'Concat two unicodes'),
  assert(Binaries::fromHex('F09F8085') as String, Strings::fromCharCode(55356) ++ Strings::fromCharCode(56325), 'Generate unicode from hexa'),
])