package org.mule.weave.v2.interpreted.exception

import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.parser.location.LocationCapable

class WeaveStackOverflowException(locationCapable: LocationCapable, maxStack: Int) extends ExecutionException {
  override def location: Location = locationCapable.location()

  override def message: String = s"Stack Overflow. Max stack is ${maxStack}"
}
