package org.mule.weave.v2.interpreted.listener

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.runtime.ExecutableWeave

class NotificationManager(val valueNodeListeners: Array[WeaveExecutionListener]) {

  val nonEmpty: Boolean = valueNodeListeners.length > 0

  def onExecutionStarted(executableWeave: ExecutableWeave[_ <: AstNode])(implicit ctx: EvaluationContext): Unit = {
    if (nonEmpty)
      valueNodeListeners.foreach((nodeListener) => nodeListener.onExecutionStarted(executableWeave))
  }

  def preValueNodeExecution(node: ValueNode[_])(implicit ctx: ExecutionContext) = {
    if (nonEmpty)
      valueNodeListeners.foreach((nodeListener) => nodeListener.preExecution(node))
  }

  def postValueNodeExecution(node: ValueNode[_], result: Value[_])(implicit ctx: ExecutionContext) = {
    if (nonEmpty)
      valueNodeListeners.foreach((nodeListener) => nodeListener.postExecution(node, result))
  }

  def postValueNodeExecution(node: ValueNode[_], e: Exception)(implicit ctx: ExecutionContext) = {
    if (nonEmpty)
      valueNodeListeners.foreach((nodeListener) => nodeListener.postExecution(node, e))
  }

  def onExecutionEnded(executableWeave: ExecutableWeave[_ <: AstNode])(implicit ctx: EvaluationContext): Unit = {
    if (nonEmpty)
      valueNodeListeners.foreach((nodeListener) => nodeListener.onExecutionEnded(executableWeave))
  }

}

object NotificationManager {

  val EMPTY = NotificationManager()

  def apply(valueNodeListeners: Array[WeaveExecutionListener] = Array()) = new NotificationManager(valueNodeListeners)
}