package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.core.exception._
import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value

class ExistsSelectorNode(rhs: ValueNode[_]) extends ValueNode[Boolean] {

  val FALSE = BooleanValue(value = false, this)

  val TRUE = BooleanValue(value = true, this)

  override def doExecute(implicit ctx: ExecutionContext): Value[Boolean] = {
    try {
      rhs.execute
      TRUE
    } catch {
      case e: InvalidSelectionException => FALSE
    }
  }
}

object ExistsSelectorNode {
  def apply(rhs: ValueNode[_]): ExistsSelectorNode = new ExistsSelectorNode(rhs)
}
