package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.structure.header.directives.VarDirective
import org.mule.weave.v2.model.values.Value

class UsingNode(declarations: Seq[VarDirective], astNode: ValueNode[_]) extends ValueNode[Any] with Product2[Seq[VarDirective], ValueNode[_]] {

  override protected def doExecute(implicit ctx: ExecutionContext): Value[Any] = {
    ctx.runInNewFrame(this, Some("Using-Block"), {
      val decls = declarations.toIterator
      while (decls.hasNext) {
        decls.next().execute
      }
      astNode.execute(ctx)
    })
  }

  override def _1: Seq[VarDirective] = declarations

  override def _2: ValueNode[_] = astNode

}

object UsingNode {
  def apply(declarations: Seq[VarDirective], astNode: ValueNode[_]): ValueNode[Any] = {
    new UsingNode(declarations, astNode)
  }
}

