package org.mule.weave.v2.interpreted.node.structure.header.directives

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.NameSlot
import org.mule.weave.v2.interpreted.node.structure.UriNode
import org.mule.weave.v2.model.structure.Namespace
import org.mule.weave.v2.model.values.NamespaceValue

class NamespaceDirective(val prefix: NameSlot, val uri: UriNode, callWriter: Boolean) extends Directive with Product2[NameSlot, UriNode] {

  override def execute(implicit ctx: ExecutionContext): Unit = {
    val uriString = uri.execute.evaluate.toString
    val prefixName: String = prefix.name
    ctx.executionStack().setVariable(prefix.slot, NamespaceValue(Namespace(prefixName, uriString), this))
    if (callWriter) {
      ctx.writer.foreach(_.defineNamespace(prefix, prefixName, uriString))
    }
  }

  override def _1: NameSlot = prefix

  override def _2: UriNode = uri
}
