package org.mule.weave.v2.interpreted.transform

import org.mule.weave.v2.interpreted.node.structure.DocumentNode
import org.mule.weave.v2.interpreted.node.structure.header.directives.ImportDirective
import org.mule.weave.v2.parser
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNodeHelper
import org.mule.weave.v2.parser.ast.header.directives.VersionDirective
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.runtime.exception.CompilationExecutionException

trait EngineDocumentTransformations extends EngineImportTransformations {

  def transformDocumentNode(dn: parser.ast.structure.DocumentNode): DocumentNode = {
    val importedModules: Seq[ImportDirective] = transformImportDirectives(dn)
    val maybeVersionDirective: Option[VersionDirective] = dn.header.directives.collectFirst({
      case vd: VersionDirective => vd
    })

    var privileges: Option[Seq[String]] = None
    if (maybeVersionDirective.isDefined) {
      val vd = maybeVersionDirective.get

      // UntrustedCode
      val maybeUntrustedCodeAnnotation: Option[AnnotationNode] = vd.codeAnnotations.find(an => {
        val annotationReference = scopeNavigator().resolveVariable(an.name)
        annotationReference.exists(ref => {
          ref.fqnReferenceName == NameIdentifier.UNTRUSTED_CODE_ANNOTATION
        })
      })

      if (maybeUntrustedCodeAnnotation.isDefined) {
        val untrustedCodeAnnotation = maybeUntrustedCodeAnnotation.get
        val maybePrivileges: Option[Seq[String]] = AnnotationNodeHelper.argStringSeq("privileges", untrustedCodeAnnotation)
        privileges = AnnotationNodeHelper.argStringSeq("privileges", untrustedCodeAnnotation)
        if (maybePrivileges.isDefined) {
          privileges = maybePrivileges
        } else {
          throw new CompilationExecutionException(untrustedCodeAnnotation.location(), "Missing required argument `privileges`")
        }
      }
    }
    new DocumentNode(importedModules.toArray, transform(dn.header), transform(dn.root), privileges)
  }
}
