package org.mule.weave.v2.interpreted.transform

import org.mule.weave.v2.interpreted.node.structure.header.ExternalBindings
import org.mule.weave.v2.interpreted.node.structure.header.HeaderNode
import org.mule.weave.v2.interpreted.node.structure.header.VariableTable
import org.mule.weave.v2.parser.ast.header.directives.AnnotationDirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.ImportDirective
import org.mule.weave.v2.parser.ast.header.directives.InputDirective

trait EngineHeaderTransformations extends AstTransformation {

  val _variablesTable: VariableTable

  val _modulesNameTable: VariableTable

  val _externalBindings: ExternalBindings

  def transformHeaderNode(directives: Seq[DirectiveNode]): HeaderNode = {
    //We filter import directives as they are not used in runtime
    val runtimeDirectives = directives.filterNot((directive) => directive.isInstanceOf[ImportDirective] || directive.isInstanceOf[InputDirective] || directive.isInstanceOf[AnnotationDirectiveNode])
    new HeaderNode(transformSeq(runtimeDirectives), _variablesTable, _modulesNameTable, _externalBindings)
  }
}
