package org.mule.weave.v2.runtime.core.exception

import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.model.types.Type
import org.mule.weave.v2.parser.location.Location

class InvalidComparisonException(leftType: Type, rightType: Type, val location: Location) extends ExecutionException {

  override def message: String = {
    s"Types `${leftType.name}` and `${rightType.name}` can not be compared."
  }
}
