package org.mule.weave.v2.runtime.core.functions

import java.time.temporal.ChronoUnit

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.LocalDateType
import org.mule.weave.v2.model.values._

/**
  * Gives the number of days between two dates.
  */
object DaysBetweenFunctionValue extends BinaryFunctionValue {

  override val L = LocalDateType
  override val R = LocalDateType
  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val from = LocalDateType.coerce(leftValue, this).evaluate
    val to = LocalDateType.coerce(rightValue, this).evaluate
    val daysBetween = ChronoUnit.DAYS.between(from, to)
    NumberValue(daysBetween)
  }
}
