package org.mule.weave.v2.runtime.core.functions.collections

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.core.io.SeekableStream
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values._
import org.mule.weave.v2.model.types.BinaryType
import org.mule.weave.v2.model.values.math.Number

object ArraySizeOfFunctionValue extends UnaryFunctionValue {
  override val R = ArrayType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    NumberValue(Number(v.evaluate.size()), this)
  }
}

object BinarySizeOfFunctionValue extends UnaryFunctionValue {
  override val R = BinaryType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    val is: SeekableStream = v.evaluate
    NumberValue(Number(is.size()), this)
  }
}

object ObjectSizeOfFunctionValue extends UnaryFunctionValue {
  override val R = ObjectType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    val size = Number(v.evaluate.size())
    NumberValue(size, this)
  }
}

object StringSizeOfFunctionValue extends UnaryFunctionValue {
  override val R = StringType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] =
    NumberValue(Number(v.evaluate.length), this)
}