package org.mule.weave.v2.runtime.core.functions.collections

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.values.RangeHelper
import org.mule.weave.v2.model.values.RangeValue
import org.mule.weave.v2.model.values.Value
/**
  * Creates a range using the left as lower bound and right as upper bound
  */
object ToRangeFunctionValue extends BinaryFunctionValue {
  val L = NumberType
  val R = NumberType

  override def doExecute(lhs: L.V, rhs: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    val startInt = lhs.evaluate
    val endInt = rhs.evaluate
    val value = RangeHelper.inclusiveRange(startInt, endInt)
    RangeValue(value, this)
  }
}