package org.mule.weave.v2.runtime.core.functions.runtime

import java.io.InputStream

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.ServiceManager
import org.mule.weave.v2.model.service.InMemoryLoggingService
import org.mule.weave.v2.model.values.BinaryValue
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.model.values.ObjectValueBuilder
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.runtime.DataWeaveResult
import org.mule.weave.v2.runtime.DataWeaveScript
import org.mule.weave.v2.runtime.ScriptingBindings

object RunScriptFunctionValue extends BaseRunFunctionValue {

  private def buildSuccessResult(logger: InMemoryLoggingService, result: DataWeaveResult)(implicit ctx: EvaluationContext): ObjectValue = {
    val successResult = new ObjectValueBuilder()
    val value = result.getContent()
    val wvalue = value match {
      case is: InputStream => {
        //We need to close this input stream when the execution ends
        ctx.serviceManager.resource.registerCloseable(is)
        BinaryValue(is)
      }
      case _ => {
        BinaryValue(result.getContentAsString().getBytes(result.getCharset().name()))
      }
    }
    successResult.addPair("value", wvalue)
    successResult.addPair("mimeType", result.getMimeType())
    successResult.addPair("encoding", result.getCharset().name())
    successResult.addPair("logs", buildLogs(logger))
    successResult.build
  }

  override protected def onSecureExecution(mainFileValue: First.V, fileSystemValue: Second.V, readerValues: Third.V, inputsValue: Forth.V, runtimeConfigurationValue: Fifth.V)(implicit ctx: EvaluationContext): Value[_] = {
    val executionCallback: (DataWeaveScript, ScriptingBindings, ServiceManager, InMemoryLoggingService) => ObjectValue =
      (weaveScript, bindings, manager, inMemoryLoggingService) => {
        val weaveResult: DataWeaveResult = weaveScript.write(bindings, manager)
        buildSuccessResult(inMemoryLoggingService, weaveResult)
      }
    doExecute(mainFileValue, fileSystemValue, readerValues, inputsValue, runtimeConfigurationValue, executionCallback)
  }
}
