package org.mule.weave.v2.runtime.core.functions.stringops

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value

object StringSingularizeFunctionValue extends UnaryFunctionValue {
  override val R = StringType

  override def doExecute(v: StringSingularizeFunctionValue.R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    val str = v.evaluate.toString

    if (str.isEmpty)
      StringValue.empty
    else
      StringValue(Inflector.singularize(str), this)
  }
}

object SingularizeFunctionValue {
  val value = Seq(StringSingularizeFunctionValue)
}
