package org.mule.weave.v2.runtime.core.functions.types

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.KeyValuePair
import org.mule.weave.v2.model.types.FunctionType
import org.mule.weave.v2.model.types.TypeType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.KeyValue
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.TypeValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation
import org.mule.weave.v2.runtime.core.functions.types.exceptions.InvalidTypeException

object FunctionParamTypesFunction extends UnaryFunctionValue {
  override val R = TypeType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    v.evaluate.baseType match {
      case ft: FunctionType => {
        val params = ft.paramTypes
          .map((params) => {
            params.zipWithIndex
              .map((param) => {
                ObjectValue(Array(
                  KeyValuePair(KeyValue("paramType"), TypeValue(param._1.theType)),
                  KeyValuePair(KeyValue("name"), StringValue(param._1.name.getOrElse(s"param_${param._2}"))),
                  KeyValuePair(KeyValue("optional"), BooleanValue(param._1.optional))))
              })
              .toSeq
          })
          .getOrElse(Seq())
        ArrayValue(params)
      }
      case t => throw new InvalidTypeException(location, "Function", t.name)
    }
  }

}
