package org.mule.weave.v2.runtime.core.functions.types

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.FunctionType
import org.mule.weave.v2.model.types.TypeType
import org.mule.weave.v2.model.values.NullValue
import org.mule.weave.v2.model.values.TypeValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation
import org.mule.weave.v2.runtime.core.functions.types.exceptions.InvalidTypeException

object FunctionReturnTypeFunction extends UnaryFunctionValue {
  override val R = TypeType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    v.evaluate.baseType match {
      case ft: FunctionType => {
        ft.returnType
          .map((returnType) => {
            TypeValue(returnType)
          })
          .getOrElse(NullValue)
      }
      case t => throw new InvalidTypeException(location, "Function", t.name)
    }
  }

}
