package org.mule.weave.v2.runtime.core.operator.selectors

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.model.values.SchemaValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation

class AllSchemaSelectorOperator(override val location: WeaveLocation) extends UnaryFunctionValue {
  override val R = AnyType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    v.schema match {
      case Some(schema) => ObjectType.coerce(SchemaValue(schema))
      case _            => ObjectValue.empty
    }
  }
}

