package org.mule.weave.v2.interpreted.node.structure

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.FunctionType
import org.mule.weave.v2.model.values.FunctionValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.runtime.core.functions.OverloadedFunctionValue
import org.mule.weave.v2.versioncheck.SVersion

class OverloadedFunctionNode(functions: Array[ValueNode[_]] = Array.empty, name: Option[String] = None, val cacheable: Boolean) extends ValueNode[(Array[Value[_]]) => Value[_]] with Product1[Seq[ValueNode[_]]] {
  override protected def doExecute(implicit ctx: ExecutionContext): FunctionValue = {
    val functionValues: Array[FunctionValue] =
      functions
        .map((node) => {
          FunctionType.coerce(node.execute, this)
        })
    OverloadedFunctionValue.createValue(functionValues, Array.empty, name, location(), cacheable)
  }

  override def shouldNotify: Boolean = false

  override def _1: Seq[ValueNode[_]] = functions
}

class FilteredOverloadedFunctionNode(functions: Array[ValueNode[_]] = Array.empty, filters: Array[FunctionFilter], name: Option[String] = None, val cacheable: Boolean) extends ValueNode[(Array[Value[_]]) => Value[_]] with Product1[Seq[ValueNode[_]]] {
  override protected def doExecute(implicit ctx: ExecutionContext): FunctionValue = {
    val functionValues: Array[FunctionValue] =
      functions
        .map((node) => {
          FunctionType.coerce(node.execute, this)
        })
    OverloadedFunctionValue.createValue(functionValues, filters, name, location(), cacheable)
  }

  override def shouldNotify: Boolean = false

  override def _1: Seq[ValueNode[_]] = functions
}

trait FunctionFilter {
  def accept(functionValue: FunctionValue)(implicit ctx: EvaluationContext): Boolean
}

class VersionFilter(version: SVersion) extends FunctionFilter {
  override def accept(functionValue: FunctionValue)(implicit ctx: EvaluationContext): Boolean = {
    if (ctx.serviceManager.settingsService.functions().filterSince) {
      ctx.serviceManager.languageLevelService.get().asSVersion().>=(version)
    } else {
      true
    }
  }
}

object NoFilter extends FunctionFilter {
  override def accept(functionValue: FunctionValue)(implicit ctx: EvaluationContext): Boolean = true
}
