package org.mule.weave.v2.interpreted.node.structure

import org.mule.weave.v2.model.values.PeriodValue

import java.time.Duration
import java.time.Period
import java.time.temporal.TemporalAmount

class PeriodNode(v: TemporalAmount) extends LiteralValueNode[TemporalAmount] {
  val value = PeriodValue(v, this)
}

object PeriodNode {
  def apply(period: String) = {
    if (period.contains('T')) {
      new PeriodNode(Duration.parse(period))
    } else {
      new PeriodNode(Period.parse(period))
    }
  }
}
