package org.mule.weave.v2.interpreted.node.structure

import java.net.URI

import org.mule.weave.v2.model.values.UriValue

class UriNode(val v: java.net.URI) extends LiteralValueNode[URI] {
  val value: UriValue = UriValue(v, this)
}

object UriNode {
  def apply(uri: String): UriNode = {
    new UriNode(java.net.URI.create(uri))
  }
}