package org.mule.weave.v2.interpreted.node.structure.header

import org.mule.weave.v2.interpreted.node.structure.header.directives.Directive

class Header(val directives: Seq[Directive]) extends Product {
  override def productElement(n: Int): Any = directives.apply(n)

  override def productArity: Int = directives.size

  override def canEqual(that: Any): Boolean = that.isInstanceOf[Header]

  override def productPrefix: String = getClass.getSimpleName
}
