package org.mule.weave.v2.interpreted.node.structure.header

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ExecutionNode
import org.mule.weave.v2.interpreted.node.structure.header.directives.Directive
import org.mule.weave.v2.interpreted.node.structure.header.directives.NamespaceDirective
import org.mule.weave.v2.parser.ast.WeaveLocationCapable
import org.mule.weave.v2.model.values.UriValue

class HeaderNode(var directives: Seq[Directive], val variableTable: VariableTable = new VariableTable(), val moduleTable: VariableTable = new VariableTable(), val externalBindings: ExternalBindings = new ExternalBindings()) extends ExecutionNode with WeaveLocationCapable {

  override def productElement(n: Int): Any = {
    n match {
      case 0 => variableTable
      case 1 => moduleTable
      case 2 => externalBindings
      case _ => directives.apply(n - 3)
    }
  }

  override def productArity: Int = directives.length + 3

  override def canEqual(that: Any): Boolean = that.isInstanceOf[HeaderNode]

  val namespaces: Map[String, UriValue] = {
    namespaceDirective
      .map((namespaceDirective: NamespaceDirective) => {
        (namespaceDirective._1.name, namespaceDirective._2.value)
      })
      .toMap
  }

  def namespaceDirective: Seq[NamespaceDirective] = {
    directives.collect({
      case e: NamespaceDirective => e
    })
  }

  def execute(implicit executionContext: ExecutionContext): Unit = {
    directives.foreach(_.execute)
  }

}
