package org.mule.weave.v2.interpreted.node.structure.schema
import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode

import org.mule.weave.v2.model.structure.schema.SchemaProperty
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.ToStringStringValue
import org.mule.weave.v2.model.values.SchemaPropertyValue
import org.mule.weave.v2.model.values.Value

case class SchemaPropertyNode(name: ValueNode[StringType.T], value: ValueNode[_], val condition: Option[ValueNode[Boolean]]) extends ValueNode[SchemaProperty] with Product2[ValueNode[StringType.T], ValueNode[Any]] {
  override protected def doExecute(implicit ctx: ExecutionContext): Value[SchemaProperty] = {
    SchemaPropertyValue(SchemaProperty(new ToStringStringValue(name.execute), value.execute), this)
  }

  override def _1: ValueNode[StringType.T] = name

  override def _2: ValueNode[Any] = value
}
