package org.mule.weave.v2.interpreted.transform

import java.time.LocalDate
import java.time.format.DateTimeFormatter

import scala.util.Try

object DateHelper {

  def parseLocalDate(localDateStr: String): LocalDate = {
    Try(LocalDate.parse(localDateStr))
      .orElse(Try(LocalDate.parse(localDateStr, DateTimeFormatter.ISO_WEEK_DATE)))
      .orElse(Try(LocalDate.parse(localDateStr, DateTimeFormatter.ISO_ORDINAL_DATE)))
      .get
  }
}
