package org.mule.weave.v2.runtime.core.functions.runtime

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.ServiceManager
import org.mule.weave.v2.model.service.InMemoryLoggingService
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.model.values.ObjectValueBuilder
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.runtime.DataWeaveScript
import org.mule.weave.v2.runtime.ExecuteResult
import org.mule.weave.v2.runtime.ScriptingBindings

object EvalScriptFunctionValue extends BaseRunFunctionValue {

  private def buildSuccessResult(logger: InMemoryLoggingService, result: ExecuteResult)(implicit ctx: EvaluationContext): ObjectValue = {
    val successResult = new ObjectValueBuilder()
    successResult.addPair("value", result.getResult().materialize)
    successResult.addPair("logs", buildLogs(logger))
    successResult.build
  }

  override protected def onSecureExecution(mainFileValue: First.V, fileSystemValue: Second.V, readerValues: Third.V, inputsValue: Forth.V, runtimeConfigurationValue: Fifth.V)(implicit ctx: EvaluationContext): Value[_] = {
    val executionCallback: (DataWeaveScript, ScriptingBindings, ServiceManager, InMemoryLoggingService) => ObjectValue =
      (weaveScript, bindings, manager, logger) => {
        val weaveResult: ExecuteResult = weaveScript.exec(bindings, manager)
        ctx.registerCloseable(weaveResult) //Close this value when it finishes
        buildSuccessResult(logger, weaveResult)
      }
    doExecute(mainFileValue, fileSystemValue, readerValues, inputsValue, runtimeConfigurationValue, executionCallback)
  }

}
