package org.mule.weave.v2.runtime.core.functions.runtime

import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.model.values.ObjectValueBuilder
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.parser.location.Position
import org.mule.weave.v2.parser.location.WeaveLocation

object LocationBuilder {
  def buildPosition(position: Position): ObjectValue = {
    val positionResult = new ObjectValueBuilder()
    positionResult.addPair("index", position.index)
    positionResult.addPair("line", position.line)
    positionResult.addPair("column", position.column)
    positionResult.build
  }

  def buildLocation(location: WeaveLocation): ObjectValue = {
    val locationResult = new ObjectValueBuilder()
    locationResult.addPair("start", buildPosition(location.startPosition))
    locationResult.addPair("end", buildPosition(location.endPosition))
    locationResult.addPair("locationString", location.locationString)
    locationResult.addPair("text", location.source().trim)
    locationResult.addPair("sourceIdentifier", location.resourceName.name)
    locationResult.build
  }

  def buildLocation(location: Location): ObjectValue = {
    location match {
      case weaveLocation: WeaveLocation => {
        buildLocation(weaveLocation)
      }
      case _ => {
        val locationResult = new ObjectValueBuilder()
        locationResult.addPair("locationString", location.locationString)
        locationResult.build
      }
    }
  }

}
