package org.mule.weave.v2.runtime.core.functions.stringops

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.RegexType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value

import java.util.regex.Matcher
import java.util.regex.Pattern
object StringMatchesFunctionValue extends BinaryFunctionValue {
  override val L = StringType
  override val R = RegexType

  override def doExecute(leftValue: StringMatchesFunctionValue.L.V, rightValue: StringMatchesFunctionValue.R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val pattern: Pattern = rightValue.evaluate.pattern
    val matcher: Matcher = ctx.serviceManager.patternService.matcher(pattern, leftValue.evaluate, this)
    val matches: Boolean = matcher.matches()
    BooleanValue(matches, this)
  }
}

object MatchesFunctionValue {
  val value = Seq(StringMatchesFunctionValue)
}
